<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"/><xsl:import href="../../../../date.xsl"/><xsl:import href="../../../../table.xsl"/><xsl:import href="../../../../style.xsl"/><xsl:import href="../../../../lien.xsl"/><xsl:variable name="page-format" select="portrait"/><xsl:output encoding="UTF-8" method="xml" indent="yes"/><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"/><xsl:param name="nomenclaturePasEnrichie"/><xsl:variable name="nomenclature" select="document('../libellePlanCompte.xml')/n:Nomenclature"/><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"/><xsl:variable name="isPrint" select="1"/><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"/><xsl:template match="/dcfu:CompteFinancierUnique"/><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
            <meta name="generator" content="ODM"/>
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css"/>
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css"/>
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Calibri;
  panose-1:2 15 5 2 2 2 4 3 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeading8, li.MsoHeading8, div.MsoHeading8
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:11.0pt;
  font-family:"Calibri",sans-serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:11.0pt;
  font-family:"Calibri",sans-serif;}
p.MsoBodyTextIndent3, li.MsoBodyTextIndent3, div.MsoBodyTextIndent3
  {
  margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:-14.2pt;
  margin-bottom:.0001pt;
  font-size:6.0pt;
  font-family:"Times New Roman",serif;
  color:red;}
span.En-tteCar
  {
  }
span.PieddepageCar
  {
  }
span.Titre8Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.Retraitcorpsdetexte3Car
  {
  
  font-family:"Times New Roman",serif;
  color:red;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0in;}
ul
  {margin-bottom:0in;}
--&gt;
/**/
}</style></head>
         
         
         
      <body lang="EN-US"><xsl:variable name="Refer1">B33SERVINDIV</xsl:variable><xsl:variable name="Refer2" select="$docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:IdColl/@V"/><xsl:variable name="Refer3" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer1, '_', $Refer2, '_', $Refer3)"/></xsl:call-template><div id="header">
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &quot;Arial&quot;,&quot;sans-serif&quot;"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"/> - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"/> - <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"/>  - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"/></span></b></p>
               
            </div><div class="WordSection1">
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab1">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        <tr style="page-break-inside:avoid;height:14.25pt">
                           <td width="85.2%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt;height:14.25pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:12.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">I – INFORMATIONS GENERALES ET SYNTHÉTIQUES</span></b></p>
                              
                           </td>
                           <td width="14.8%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt;height:14.25pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:12.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">I</span></b></p>
                              
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="85.2%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">LISTE DES SERVICES INDIVIDUALISÉS DANS UN BUDGET ANNEXE</span></b></p>
                              
                           </td>
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">B3.3</span></b></p>
                              
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab1"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal" style="margin-right:-4.55pt"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
               
               <p class="MsoNormal" style="margin-right:-4.55pt"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab2">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_ETAB_SERVICE/n:ETAB_SERVICE[(./n:CodNatEtab/@V='02')                         and (not(./n:Groupe/@V))]"/>
                        <thead>
                           
                           <tr>
                              <td width="22%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Catégorie de services (1)</span></b></p>
                                 
                              </td>
                              <td width="30.9%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Intitulé / objet du service</span></b></p>
                                 
                              </td>
                              <td width="8.7%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Date de création</span></b></p>
                                 
                              </td>
                              <td width="8.7%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Date de délibération</span></b></p>
                                 
                              </td>
                              <td width="12.6%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">N° SIRET</span></b></p>
                                 
                              </td>
                              <td width="9.4%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Nature de l’activité</span></b></p>
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">(SPIC/SPA)</span></b></p>
                                 
                              </td>
                              <td width="7.8%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">TVA</span></b></p>
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">(oui / non)</span></b></p>
                                 
                              </td>
                           </tr>
                           
                        </thead><xsl:variable name="varOdm2" select="$varOdm1"/>
                        <xsl:variable name="varOdm3">
                           <xsl:for-each select="$varOdm2"><xsl:sort select="./n:DtCreatEtab/@V"/><xsl:variable name="ligne" select="."/>
                              <tr>
                                 <td width="22%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($ligne/n:LibCatEtab/@V)"/></span></p>
                                 </td>
                                 <td width="30.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($ligne/n:LibEtab/@V)"/></span></p>
                                 </td>
                                 <td width="8.7%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($ligne/n:DtCreatEtab/@V)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p>
                                 </td>
                                 <td width="8.7%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($ligne/n:DtDelibEtab/@V)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p>
                                 </td>
                                 <td width="12.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($ligne/n:SiretEtab/@V)"/></span></p>
                                 </td>
                                 <td width="9.4%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($ligne/n:LibNatActivEtab/@V)"/></span></p>
                                 </td>
                                 <td width="7.8%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($data/data:LibelleIndicTVAEtab/data:valeur[@value = $ligne/n:IndicTVAEtab/@V]/text())"/></span></p>
                                 </td>
                              </tr>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm4">
                           <xsl:choose>
                              <xsl:when test="count($varOdm3/*) = 0">
                                 <tr class=" #tech#">
                                    <td height="1px" width="22%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:double 1.5pt;border-bottom:double black 1.5pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="30.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="8.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="8.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="12.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="9.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="7.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm3"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm4/xhtml:tr"/>
                        </xsl:call-template>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab2"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(1) Exemples de catégories : régie à seule autonomie financière, opérations d’aménagement, service social et médico-social.</span></p>
               
            </div></body></html>
   </xsl:template></xsl:stylesheet>